// Original weapon came from WoD and MH-EelhandraTemple
// I am *NOT* the original coder, this was simply my
// favorite hidden weapon in MH maps and I always wanted
// to give it an update  -gopostal
class SushiGun expands TournamentWeapon;

var bool bAlreadyFiring;

function float RateSelf( out int bUseAltMode )
{
	local float EnemyDist;

	if ( AmmoType.AmmoAmount <=0 )
		return -2;
	if ( Pawn(Owner).Enemy == None )
	{
		bUseAltMode = 0;
		return AIRating;
	}

	EnemyDist = VSize(Pawn(Owner).Enemy.Location - Owner.Location);
	bUseAltMode = int( 600 * FRand() > EnemyDist - 140 );
	return AIRating;
}

function PlayFiring()
{
	if ( bAlreadyFiring )
	{
		AmbientSound = Misc3Sound;
		SoundVolume = Pawn(Owner).SoundDampening*255;
		LoopAnim( 'bite1', 0.7);		
	}
	else
	{
		Owner.PlaySound(FireSound, SLOT_Misc,2.0*Pawn(Owner).SoundDampening);
		PlayAnim( 'bite1', 0.7 );		
	}
	bAlreadyFiring = true;
	bWarnTarget = (FRand() < 0.2);
}

function PlayAltFiring()
{
	Owner.PlaySound(AltFireSound, SLOT_Misc,2.0*Pawn(Owner).SoundDampening);		
	PlayAnim( 'bite2', 0.6 );
}

state NormalFire
{
	function Tick( float DeltaTime )
	{
		if (Owner==None) AmbientSound=None;		
		else SetLocation(Owner.Location);
	}

	function EndState()
	{
		if (AmbientSound!=None && Owner!=None) 
			Owner.PlaySound(Misc1Sound, SLOT_Misc,2.0*Pawn(Owner).SoundDampening);
		AmbientSound = None;		
		bAlreadyFiring = false;
		Super.EndState();
	}

Begin:
	Sleep(0.2);
	SetLocation(Owner.Location);	
	Finish();
}

function AltFire( float Value )
{
	if (AmmoType.UseAmmo(6))
	{
		GotoState('AltFiring');
		if ( PlayerPawn(Owner) != None )
			PlayerPawn(Owner).ShakeView(ShakeTime, ShakeMag, ShakeVert);
		bPointing=True;
		PlayAltFiring();
		if ( !bRapidFire && (FiringSpeed > 0) )
			Pawn(Owner).PlayRecoil(FiringSpeed);
		if ( bAltInstantHit )
			TraceFire(0.0);
		else
			ProjectileFire(AltProjectileClass, AltProjectileSpeed, bAltWarnTarget);
		if ( Owner.bHidden )
			CheckVisibility();
	}
}

state AltFiring
{
Begin:
	FinishAnim();
	PlayAnim('Swimming',0.30);
	Sleep(3.0);
	Finish();			
}

function PlayIdleAnim()
{
	LoopAnim('Swimming', 0.20);
}

defaultproperties
{
   AmmoName=Class'FishAmmo'
   PickupAmmoCount=100
   bAltWarnTarget=True
   FireOffset=(X=10.00,Y=-15.00,Z=-15.00),
   ProjectileClass=Class'Fishy'
   AltProjectileClass=Class'FishEgg'
   shakemag=120.00
   AIRating=0.40
   RefireRate=0.80
   FireSound=Sound'UnrealI.Pupae.munch1p'
   AltFireSound=Sound'UnrealI.GelShot'
   SelectSound=Sound'UnrealShare.Pickups.BeltSnd'
   Misc1Sound=Sound'UnrealI.Pupae.thumppp'
   Misc3Sound=Sound'UnrealShare.Slith.SliSpawn'
   MessageNoAmmo=" needs to go fishing now."
   DeathMessage="%o was chewed up by %k's %w."
   AutoSwitchPriority=3
   InventoryGroup=5
   PickupMessage="You got a Sushi Gun!"
   ItemName="Sushi Gun"
   PlayerViewOffset=(X=1.00,Y=-1.50,Z=-1.50),
   PlayerViewMesh=LodMesh'UnrealShare.fish'
   PlayerViewScale=0.10
   PickupViewMesh=LodMesh'UnrealShare.fish'
   PickupViewScale=0.75
   ThirdPersonMesh=LodMesh'UnrealShare.fish'
   ThirdPersonScale=0.70
   PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
   Mesh=LodMesh'UnrealShare.fish'
   bNoSmooth=False
   SoundRadius=64
   SoundVolume=255
   CollisionRadius=37.00
   CollisionHeight=8.00
}
